﻿using System;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace PWS.API.Keyboard.Sample7
{
    public partial class FormMain : Form
    {
        [DllImport("user32.dll")]
        public static extern uint GetCaretBlinkTime();

        [DllImport("user32.dll")]
        public static extern bool SetCaretBlinkTime(uint uMSeconds);

        public FormMain()
        {
            InitializeComponent();
        }

        private void buttonGetCaretBlinkTime_Click(object sender, EventArgs e)
        {
            uint caretBlinkTime = GetCaretBlinkTime();
            MessageBox.Show(caretBlinkTime.ToString());
        }

        private void buttonSetCaretBlinkTime_Click(object sender, EventArgs e)
        {
            uint caretBlinkTime;
            uint.TryParse(textBoxValue.Text, out caretBlinkTime);
            SetCaretBlinkTime(caretBlinkTime);
        }
    }
}